//
//  riskass_form.m
//  EC145
//
//  Created by KulanaMac on 5/26/14.
//
//

#import "riskass_form.h"


@implementation riskass_form

@synthesize Title;
@synthesize yellowThreshold;
@synthesize orangeThreshold;
@synthesize redThreshold;
@synthesize recomm_green;
@synthesize recomm_yellow;
@synthesize recomm_orange;
@synthesize recomm_red;

@synthesize categories;
@synthesize maxPoints;


-(id) initWithTitle:(NSString*)theTitle AndYellowT:(int)theYellowT AndOrangeT:(int)theOrangeT AndRedT:(int)theRedT AndRecGreen:(NSString*)theRGreen AndRecYellow:(NSString*)theRYellow AndRecOrange:(NSString*)theROrange AndRecRed:(NSString*)theRRed;

{
    Title=theTitle;
    yellowThreshold=theYellowT;
    orangeThreshold=theOrangeT;
    redThreshold=theRedT;
    recomm_green=theRGreen;
    recomm_yellow=theRYellow;
    recomm_orange=theROrange;
    recomm_red=theRRed;
    categories=[[NSMutableArray alloc] init];
    return self;
}



- (id) initWithCoder: (NSCoder *)coder
{
    if (self = [super init])
    {
    	self.Title = [coder decodeObjectForKey:@"Title"];
    	self.yellowThreshold = [[coder decodeObjectForKey:@"yellowThreshold"] intValue];
        self.orangeThreshold = [[coder decodeObjectForKey:@"orangeThreshold"] intValue];
        self.redThreshold = [[coder decodeObjectForKey:@"redThreshold"] intValue];
        self.recomm_green = [coder decodeObjectForKey:@"recomm_green"];
        self.recomm_yellow = [coder decodeObjectForKey:@"recomm_yellow"];
        self.recomm_orange = [coder decodeObjectForKey:@"recomm_orange"];
        self.recomm_red = [coder decodeObjectForKey:@"recomm_red"];
    	self.categories = [coder decodeObjectForKey:@"categories"];
        self.maxPoints = [[coder decodeObjectForKey:@"maxPoints"] intValue];
    }
    return self;
}

- (void) encodeWithCoder: (NSCoder *)coder
{
    [coder encodeObject:Title forKey:@"Title"];
    [coder encodeObject:[[NSString alloc] initWithFormat:@"%i",yellowThreshold] forKey:@"yellowThreshold"];
    [coder encodeObject:[[NSString alloc] initWithFormat:@"%i",orangeThreshold] forKey:@"orangeThreshold"];
    [coder encodeObject:[[NSString alloc] initWithFormat:@"%i",redThreshold] forKey:@"redThreshold"];
    [coder encodeObject:recomm_green forKey:@"recomm_green"];
    [coder encodeObject:recomm_yellow forKey:@"recomm_yellow"];
    [coder encodeObject:recomm_orange forKey:@"recomm_orange"];
    [coder encodeObject:recomm_red forKey:@"recomm_red"];
    [coder encodeObject:categories forKey:@"categories"];
    [coder encodeObject:[[NSString alloc] initWithFormat:@"%i",maxPoints] forKey:@"maxPoints"];

}

-(void) setCategories:(NSMutableArray *)theCategories
{
    categories =[NSMutableArray arrayWithArray:theCategories];

}

-(void) addCategory:(riskass_category *)cat
{
    [categories addObject:cat];
}

-(riskass_category *) getCategory:(int) i {
    return [categories objectAtIndex:i];
}

-(void) setMaxPoints:(int)theMaxPoints {
    maxPoints=theMaxPoints;
}

@end
